% "Olfactory behaviors assayed by computer tracking of Drosophila in a 
% four-quadrant olfactometer".
% 
% AUTHORS: 
% Chun-Chieh Lin, Olena Riabinina, Christopher J.Potter
% 
% The Solomon H. Snyder Department of Neuroscience, Center for Sensory 
% Biology, Johns Hopkins University School of Medicine, 
% Baltimore, MD 21205, USA. cpotter@jhmi.edu

% Source: Potter Lab, Johns Hopkins University School of Medicine 
figure
plot(nx,ny,'.r', 'MarkerSize', 4)
axis equal
hold on
xa=t_ans(1);
ya=t_ans(2);
ang=t_ans(3);
xc=[xa+Rdist*cos(ang); xa+Rdist*cos(ang-pi/2); ...
xa-Rdist*cos(ang); xa-Rdist*cos(ang-pi/2)];
yc=[ya+Rdist*sin(ang); ya+Rdist*sin(ang-pi/2); ...
ya-Rdist*sin(ang); ya-Rdist*sin(ang-pi/2)];

h1=DrawCircularMask(xc(1), yc(1), R);
h2=DrawCircularMask(xc(1), yc(1), R+dR);
h3=DrawCircularMask(xc(2), yc(2), R+dR);
h4=DrawCircularMask(xc(2), yc(2), R);
h5=DrawCircularMask(xc(3), yc(3), R);
h6=DrawCircularMask(xc(3), yc(3), R+dR);
h7=DrawCircularMask(xc(4), yc(4), R+dR);
h8=DrawCircularMask(xc(4), yc(4), R);
set([h1 h2 h3 h4 h5 h6 h7 h8], 'Color', 'k')


xa=xa0;
ya=ya0;
ang=ang0;
xc=[xa+Rdist*cos(ang); xa+Rdist*cos(ang-pi/2); ...
xa-Rdist*cos(ang); xa-Rdist*cos(ang-pi/2)];
yc=[ya+Rdist*sin(ang); ya+Rdist*sin(ang-pi/2); ...
ya-Rdist*sin(ang); ya-Rdist*sin(ang-pi/2)];
h1=DrawCircularMask(xc(1), yc(1), R);
h2=DrawCircularMask(xc(1), yc(1), R+dR);
h3=DrawCircularMask(xc(2), yc(2), R+dR);
h4=DrawCircularMask(xc(2), yc(2), R);
h5=DrawCircularMask(xc(3), yc(3), R);
h6=DrawCircularMask(xc(3), yc(3), R+dR);
h7=DrawCircularMask(xc(4), yc(4), R+dR);
h8=DrawCircularMask(xc(4), yc(4), R);
set([h1 h2 h3 h4 h5 h6 h7 h8], 'Color', 'r')